<?php
// Cas 1 : Système de gestion d'utilisateurs

class UserManager {
    public function register(string $name, string $email, string $password): void {
        if(empty($name) || empty($email) || empty($password)) {
            throw new Exception("Données invalides");
        }
        
        if(!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            throw new Exception("Email invalide");
        }
        
        if(strlen($password) < 8) {
            throw new Exception("Mot de passe trop court");
        }
        
        $hashedPassword = password_hash($password, PASSWORD_BCRYPT);
        
        $db = new PDO('mysql:host=localhost;dbname=app','root','');
        $stmt = $db->prepare('INSERT INTO users (name,email,password) VALUES (?,?,?)');
        $stmt->execute([$name, $email, $hashedPassword]);
        $userId = $db->lastInsertId();
        
        $subject = "Bienvenue $name!";
        $message = "Votre compte a été créé avec succès.";
        mail($email, $subject, $message);
        
        error_log("User registered: $userId - $email");
    }
    
    public function authenticate(string $email, string $password): ?array {
        $db = new PDO('mysql:host=localhost;dbname=app','root','');
        $stmt = $db->prepare('SELECT * FROM users WHERE email = ?');
        $stmt->execute([$email]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if(!$user || !password_verify($password, $user['password'])) {
            error_log("Failed login attempt: $email");
            return null;
        }
        
        error_log("Successful login: {$user['id']} - $email");
        return $user;
    }
}

/*
=== USER STORIES ===

US1: En tant que développeur, je veux pouvoir tester la logique d'authentification 
     sans avoir besoin d'une vraie base de données.

US2: En tant que product owner, je veux remplacer l'envoi d'email par SMS 
     par un service externe (Twilio) pour les nouveaux utilisateurs.

US3: En tant que développeur, je veux changer le système de logs pour utiliser 
     Monolog au lieu de error_log().

US4: En tant que développeur, je veux ajouter une validation qui vérifie que 
     l'email n'existe pas déjà en base avant l'insertion.
*/
