<?php
// Cas 2 : Système de traitement de factures

class InvoiceProcessor {
    public function process(array $items, string $customerEmail, string $format): void {
        $total = 0;
        foreach($items as $item) {
            $total += $item['price'] * $item['quantity'];
        }
        
        $taxRate = 0.20;
        $tax = $total * $taxRate;
        $finalTotal = $total + $tax;
        
        if($format === 'pdf') {
            $content = "FACTURE\n\nTotal HT: $total EUR\nTVA: $tax EUR\nTotal TTC: $finalTotal EUR";
            file_put_contents("/tmp/invoice.pdf", $content);
        } elseif($format === 'html') {
            $content = "<h1>FACTURE</h1><p>Total: $finalTotal EUR</p>";
            file_put_contents("/tmp/invoice.html", $content);
        }
        
        $db = new PDO('mysql:host=localhost;dbname=invoices','root','');
        $stmt = $db->prepare('INSERT INTO invoices (total,tax,customer_email) VALUES (?,?,?)');
        $stmt->execute([$total, $tax, $customerEmail]);
        
        mail($customerEmail, "Votre facture", "Votre facture est prête.");
    }
    
    public function applyDiscount(float $total, string $customerType): float {
        if($customerType === 'vip') {
            return $total * 0.90;
        } elseif($customerType === 'regular') {
            return $total * 0.95;
        }
        return $total;
    }
}

/*
=== USER STORIES ===

US1: En tant que comptable, je veux pouvoir générer des factures au format Excel 
     en plus de PDF et HTML.

US2: En tant que développeur, je veux écrire des tests unitaires pour le calcul 
     des taxes sans dépendre de la base de données.

US3: En tant que product owner, je veux ajouter un nouveau type de client "entreprise" 
     avec 10% de réduction.

US4: En tant que développeur, je veux remplacer l'envoi par email par un système 
     de notification (email, SMS ou push) selon les préférences du client.

US5: En tant que comptable, je veux appliquer des taux de TVA différents selon 
     le type de produit (alimentaire 5.5%, autres 20%).
*/
