<?php
// Cas 4 : Système de gestion de contenu

interface Content {
    public function publish(): void;
    public function unpublish(): void;
    public function delete(): void;
    public function schedulePublication(DateTime $date): void;
    public function addComment(string $author, string $text): void;
    public function likeContent(int $userId): void;
}

class Article implements Content {
    private string $title;
    private string $body;
    private bool $published = false;
    private array $comments = [];
    
    public function publish(): void {
        $this->published = true;
        $db = new PDO('mysql:host=localhost;dbname=cms','root','');
        $stmt = $db->prepare('UPDATE articles SET published = 1 WHERE id = ?');
        $stmt->execute([$this->id]);
    }
    
    public function unpublish(): void { $this->published = false; }
    public function delete(): void { /* ... */ }
    public function schedulePublication(DateTime $date): void { /* ... */ }
    public function addComment(string $author, string $text): void { 
        $this->comments[] = ['author' => $author, 'text' => $text]; 
    }
    public function likeContent(int $userId): void { /* ... */ }
}

class StaticPage implements Content {
    private string $title;
    private string $content;
    
    public function publish(): void { /* Les pages statiques sont toujours publiées */ }
    public function unpublish(): void { 
        throw new Exception("Les pages statiques ne peuvent pas être dépubliées"); 
    }
    public function delete(): void {
        throw new Exception("Les pages statiques ne peuvent pas être supprimées");
    }
    public function schedulePublication(DateTime $date): void {
        throw new Exception("Les pages statiques ne supportent pas la planification");
    }
    public function addComment(string $author, string $text): void {
        throw new Exception("Les pages statiques ne supportent pas les commentaires");
    }
    public function likeContent(int $userId): void {
        throw new Exception("Les pages statiques ne supportent pas les likes");
    }
}

class Banner implements Content {
    private string $imageUrl;
    private string $link;
    
    public function publish(): void { /* ... */ }
    public function unpublish(): void { /* ... */ }
    public function delete(): void { /* ... */ }
    public function schedulePublication(DateTime $date): void { /* ... */ }
    
    public function addComment(string $author, string $text): void {
        throw new Exception("Les bannières ne supportent pas les commentaires");
    }
    public function likeContent(int $userId): void {
        throw new Exception("Les bannières ne supportent pas les likes");
    }
}

/*
=== USER STORIES ===

US1: En tant que développeur, je veux créer un nouveau type de contenu "Video" 
     qui supporte publication, suppression et likes, mais pas les commentaires.

US2: En tant que content manager, je veux lister tous les contenus qui supportent 
     les commentaires sans avoir à gérer des exceptions.

US3: En tant que développeur, je veux écrire du code générique qui manipule 
     n'importe quel contenu sans risquer des exceptions inattendues.

US4: En tant que product owner, je veux ajouter un nouveau type "Newsletter" 
     qui peut être publié et planifié, mais ne supporte ni commentaires, ni likes, 
     ni suppression (les newsletters restent archivées).
*/
